package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 金币支出码
 *
 * @author ElinZhou
 * @version $Id: CoinExpenseCode.java , v 0.1 2017/12/30 下午3:56 ElinZhou Exp $
 */
public enum CoinExpenseCode implements CoinTradeCode {

    /**
     * 金币结算
     */
    SETTLE(1, "金币结算"),

    HAOWAN_GAME(2, "好玩小游戏"),

    /**
     * 红包农场刷新附近的人消耗
     */
    REFRESH_STANGER(3,"红包农场"),

    /**
     * 红包农场被狗咬
     */
    BEAT_BY_DOG(4,"红包农场"),

    /**
     * 风控命中扣除
     */
    RISK_MANAGEMENT(5,"金币收回：违规收益扣除")
    ;


    private Integer code;

    private String desc;

    private static final Map<Integer, CoinExpenseCode> CACHE = Maps.uniqueIndex(Arrays.asList(CoinExpenseCode.values()),
            CoinExpenseCode::getCode);

    public Integer getCode() {
        return code;
    }

    CoinExpenseCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public Long getTaskId() {
        return Long.valueOf(code);
    }

    @Override
    public String getTaskDescription() {
        return desc;
    }

    public static CoinExpenseCode getByCode(Integer code) {
        CoinExpenseCode coinExpenseCode = CACHE.get(code);
        if (coinExpenseCode != null) {
            return coinExpenseCode;
        }
        return null;
    }
}
