package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.rsp.VersionRewardDto;
import cn.com.duiba.tuia.news.center.dto.rsp.VersionRewardMainDto;

import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2018/8/23 19:40
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteVersionRewardService {

   Long getNormalReward();
   /**
    * 根据版本号获取渠道列表
    * @param version
    * @return
    */
   List<VersionRewardDto> getList(Long version);

   /**
    * 获取版本的列表
    * @return
    */
   List<VersionRewardMainDto> getMainList();

   /**
    * 更新渠道金额
    * @param id
    * @param reward
    * @param source
    * @return
    */
   boolean update(Long id,Long reward,String source);


   /**
    * 增加渠道奖励
    * @param rewad
    * @param source
    * @return
    */
   boolean add(Long rewad,String source,Long version) throws BizException;


   /**
    * 删除渠道奖励
    * @param id
    * @return
    */
   boolean del(Long id);



   /**
    * 增加版本奖励
    * @param rewad
    * @param version
    * @return
    */
   boolean addMainReward(Long rewad,Long version) throws BizException;



   /**
    * 更新版本奖励
    * @param id
    * @param reward
    * @return
    */
   boolean updateForMainReward(Long id,Long reward);














}
