package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum ActivityFunType {
                          /**
                           * timeLimitPacket
                           */
                          LIMIT_PACKET("timeLimitPacket"),
    /**
     * groupRedPacket
     */
    GROUP_RED_PACKET("groupRedPacket"),
    /**
     * clickTwiceEarn
     */
    CLICK_TWICE_EARN("clickTwiceEarn"),

    ;

    private String name;

    public String getName() {
        return name;
    }

    ActivityFunType(String name) {
        this.name = name;
    }

    private static final Map<String, ActivityFunType> CACHE = Maps.uniqueIndex(Arrays.asList(ActivityFunType
            .values()), ActivityFunType::getName);

    public static ActivityFunType of(String name) {
        return CACHE.get(name);
    }


}
