package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteMoneyTreeService.java , v 0.1 2018-12-24 13:57 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteMoneyTreeService {

    /**
     * 查询昨日金币收入
     * 当今日收获过金币后，将无法获取该数值
     *
     * @param userId
     * @return 最后有收获过金币的一天获得的总金币
     */
    long queryLastIncome(Long userId);


    /**
     * 摘取获得金币
     *
     * @param userId 金币数
     * @param coins  收获零钱数
     */
    void pick(Long userId, Long coins);

}
