package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpGoodsDto;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpUserInfoDto;

import java.util.List;

/**
 * 拼多多助力免单活动的remoteService
 * @author lichao 2019/1/22
 */
@AdvancedFeignClient
public interface RemotePddHelpService {

    /** 查找今日免费的列表 */
    List<PddHelpGoodsDto> findGoodsList(Integer pageId,Integer pageSize);

    /** 查询免费的商品详情 */
    PddHelpGoodsDto findHelpGood(Long goodsId);

    /**
     * 查询参与用地址信息
     * @param userId 用户id
     * @return
     */
    List<PddHelpUserInfoDto> findUserInfoById(Long userId);

    /**
     * 新增参与用地址
     * @param dto 用户地址信息
     * @return
     */
    Boolean addUserAddr(PddHelpUserInfoDto dto);
}
