package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum WithdrawStatus {
    /**
     * 未执行
     */
    INIT(0,"未执行"),

    /**
     * 打款成功
     */
    SUCCESS(1,"打款成功"),

    /**
     * 打款失败
     */
    FAIL(2,"打款失败")
    ;
    private static final Map<Integer, WithdrawStatus> CACHE = Maps.uniqueIndex(Arrays.asList(WithdrawStatus
            .values()), WithdrawStatus::getCode);

    private Integer code;
    private String desc;

    WithdrawStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static WithdrawStatus of(Integer aCode) {
        return CACHE.get(aCode);
    }

}
