package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpGoodsDto;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpOrderDto;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpJoinerDto;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpUserInfoDto;
import cn.com.duiba.tuia.news.center.dto.pdd.help.PddHelpShareItemDto;
import cn.com.duiba.tuia.news.center.dto.req.BaseQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.pojo.PddHelpOrderReq;

import java.util.List;

/**
 * 拼多多助力免单活动的remoteService
 * @author lichao 2019/1/22
 */
@AdvancedFeignClient
public interface RemotePddHelpService {

    /** 查找今日免费的列表 */
    List<PddHelpGoodsDto> findGoodsList(Integer pageId,Integer pageSize);

    /** 查询免费的商品详情 */
    PddHelpGoodsDto findHelpGood(Long goodsId);

    /** 批量查询商品*/
    List<PddHelpGoodsDto> findHelpGoodsById(List<Long> goodIds);

    /**
     * 查询参与用地址信息
     * @param userId 用户id
     * @return
     */
    List<PddHelpUserInfoDto> findUserInfoById(Long userId);

    /**
     * 新增参与用地址
     * @param dto 用户地址信息
     * @return
     */
    Boolean addUserAddr(PddHelpUserInfoDto dto);

    /** 查询或新增当前分享的状况 */
    PddHelpShareItemDto findOrInsertShareItem(Long userId, Long goodsId);

    /**
     * 获取助力商品列表
     * @return
     */
    PageQueryResultDto<PddHelpGoodsDto> findGoodsList4Table(BaseQueryDto dto);

    /**
     * 获取助力订单列表
     * @return
     */
    PageQueryResultDto<PddHelpOrderDto> findOrderList(PddHelpOrderReq req);

    /** 获得助力订单详情 */
    PddHelpOrderDto findOrderDetail(Long orderId);

    /**
     * 保存助力商品
     * @param dto
     * @return
     */
    Boolean savePddHelpGoods(PddHelpGoodsDto dto);

    /**
     * 保存助力订单
     * @param dto
     * @return
     */
    Boolean savePddHelpOrders(PddHelpOrderDto dto);

    /**
     * 删除拼多多商品
     * @param id
     * @return
     */
    Boolean deletePddHelpGood(Long id);



    /** 获取助力者详情 */
    List<PddHelpJoinerDto> findAllJoiners(Long shareId);

    /**
     * 查询分享状况
     */
    PddHelpShareItemDto findShareItem(Long shareId);

    /** 查询我的所有的分享 */
    List<PddHelpShareItemDto> findShareItemList(Long userId,Integer pageId,Integer pageSize);

    /**
     * 获取助力邀请码
     */
    Long getInstallId(Long shareId);
}
