package cn.com.duiba.tuia.news.center.enums.loginReward;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.support.ManagedMap;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 土地任务
 */
public enum LoginRewardEnum {

    LOGIN(1, "登录天天趣闻", 1L,0L,1099511627775L),

    READ(2, "阅读5篇文章", 5L,0L,4429709312L),

    READ2(2, "阅读2分钟文章", 8L,4429709312L,1099511627775L),

    PLANT(3, "种植3个红包", 3L,0L,1099511627775L),

    TREE(4, "种植摇钱树", 1L,0L,1099511627775L),
    ;

    /**
     * 任务ID
     */
    private Integer taskId;

    /**
     * 任务描述
     */
    private String taskDescription;

    /**
     * 达标值
     */
    private Long allPlan;

    /**
     * 开始使用版本
     */
    private Long versionStart;

    /**
     * 结束使用版本
     */
    private Long versionEnd;


    public Long getVersionStart() {
        return versionStart;
    }

    public Long getVersionEnd() {
        return versionEnd;
    }

    public Integer getTaskId() {
        return taskId;
    }

    public Long getAllPlan() {
        return allPlan;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    private static final Map<Integer, List<LoginRewardEnum>> CACHE =
            Arrays.stream(LoginRewardEnum.values()).collect(Collectors.groupingBy(LoginRewardEnum::getTaskId, ManagedMap::new,Collectors.toList()));

    LoginRewardEnum(Integer taskId, String taskDescription, Long allPlan, Long versionStart, Long versionEnd) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
        this.allPlan = allPlan;
        this.versionStart = versionStart;
        this.versionEnd = versionEnd;
    }

    public static LoginRewardEnum getByTaskId(Integer taskId,Long version) {
       List<LoginRewardEnum> rewardTaskTypeList = CACHE.get(taskId);
        LoginRewardEnum result = LOGIN;
        if (CollectionUtils.isNotEmpty(rewardTaskTypeList)) {
            for (LoginRewardEnum loginRewardEnum :LoginRewardEnum.values()) {
                if(loginRewardEnum.getVersionStart()<=version && loginRewardEnum.getVersionEnd()>version){
                    result = loginRewardEnum;
                    break;
                }
            }
        }
        return result;
    }


}
