package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.BusinessBindingDto;
import cn.com.duiba.tuia.news.center.dto.DistributeBasicDto;
import cn.com.duiba.tuia.news.center.dto.BusinessUserDto;
import cn.com.duiba.tuia.news.center.dto.req.BaseQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;

/**
 * 线下分销
 * Created by xuefeng on 2018/12/11.
 */
@AdvancedFeignClient
public interface RemoteDistributionService {

    /**
     * 根据id查询
     * @param code
     * @return
     */
    BusinessUserDto selectByCode(String code);

    /**
     * 更新商户信息
     * @param businessUserReq
     * @return
     */
    Boolean updateBusinessUser(BusinessUserDto businessUserReq);

    /**
     * 查询商户列表
     * @param baseQueryDto
     * @return
     */
    PageQueryResultDto<BusinessUserDto> getList(BaseQueryDto baseQueryDto);

    /**
     * 查询商户列表
     * @return
     */
    DistributeBasicDto getBasicConfig();

    /**
     * 更新基础配置信息
     * @param distributeBasicReq
     * @return
     */
    Boolean updateBasicConfig(DistributeBasicDto distributeBasicReq);

    /**
     * 生成随机商家码
     * @return
     */
    String getCode();
}
