package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.OrderType;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ChangeOrderDto.java , v 0.1 2017/12/30 下午6:47 ZhouFeng Exp $
 */
public class ChangeOrderDto implements Serializable {

    private static final long serialVersionUID = -9024824885499265392L;
    /**
     * 流水号
     */
    private Long serialNumber;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 金币数
     */
    private Long fee;

    /**
     * 流水类型
     */
    private OrderType orderType;

    /**
     * 流水详情码 收入时参见ChangeIncomeCode，支出时参见ChangeExpenseCode
     */
    private Integer code;

    /**
     * 流水时间
     */
    private Date gmtCreate;


    public Long getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public OrderType getOrderType() {
        return orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
