package cn.com.duiba.tuia.news.center.dto.xcx;

import cn.com.duiba.tuia.news.center.enums.xcx.AcountRecordType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

@ApiModel("流水信息")
public class AccountRecordDto implements Serializable {

    private Long id;
    @ApiModelProperty("用户ID")
    private Long userId;
    @ApiModelProperty("账户ID")
    private Long accountId;
    @ApiModelProperty("流水金额")
    private Long amount;
    @ApiModelProperty("流水类型")
    private Integer recordType;
    @ApiModelProperty("流水类型描述")
    private String recordTypeStr;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Integer getRecordType() {
        return recordType;
    }

    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
        if (recordType != null) {
            AcountRecordType acountRecordType = AcountRecordType.getByCode(recordType);
            if (null != acountRecordType) {
                this.recordTypeStr = acountRecordType.getDesc();
            }
        }
    }

    public String getRecordTypeStr() {
        return recordTypeStr;
    }

    public void setRecordTypeStr(String recordTypeStr) {
        this.recordTypeStr = recordTypeStr;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
