package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 零钱支出码
 *
 * @author ElinZhou
 * @version $Id: ChangeIncomeCode.java , v 0.1 2017/12/30 下午6:48 ElinZhou Exp $
 */
public enum ChangeExpenseCode  implements ChangeTradeCode{

                                                          /**
                                                           * 提现
                                                           */
                                                          WITHDRAW(1, "提现到支付宝"),

    /**
     * 清空余额
     */
    CLEAR_ACCOUNT(2,"系统余额清零"),

    //因为bi需要单独拉数据所以，新建个类型
    MAMMON(3,"财神红包微信到账"),

    ;


    private Integer code;
    private String  desc;
    private static final Map<Integer, ChangeExpenseCode> CACHE = Maps.uniqueIndex(Arrays.asList(ChangeExpenseCode.values()),
            ChangeExpenseCode::getCode);

    ChangeExpenseCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    @Override
    public Integer getCode() {
        return code;
    }

    public static ChangeExpenseCode get(Integer code) {
        return CACHE.get(code);
    }
}
