package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

import static cn.com.duiba.tuia.news.center.enums.RewardUnit.CHANGE;
import static cn.com.duiba.tuia.news.center.enums.RewardUnit.COIN;

public enum NewUserSignInReward implements SignInReward {

    DAY_ONE(1, 12L, CHANGE),

    DAY_TWO(2, 15L, COIN),

    DAY_THREE(3, -1L, CHANGE),

    DAY_FOUR(4, 25L, COIN),

    DAY_FIVE(5, -1L, CHANGE),

    DAY_SIX(6, 35L, COIN),

    DAY_SEVEN(7, -1L, CHANGE);

    private Integer day;
    private Long rewardFee;
    private RewardUnit rewardUnit;

    private static final Map<Integer, NewUserSignInReward> CACHE = Maps.uniqueIndex(Arrays.asList(NewUserSignInReward
            .values()), NewUserSignInReward::getDay);

    NewUserSignInReward(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        // 概率计算奖励金额逻辑,采用的是随机数是否坐落在范围标识内.3%->[1,4) 如果随机数是1,2,3.则命中概率
        if (rewardFee.equals(-1L)) {
            // -1则说明是现金.签到的现金概率与登录是一样的.所以这里调用登录的随机事件
            RandomReward loginReward = RandomReward.getReward(LoginReward.values());
            return loginReward.getRewardFee();
        }
        return rewardFee;
    }

    @Override
    public Long getTopRewardNew() {
        return null;
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public static NewUserSignInReward getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("签到异常"));
    }


}