package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.SlotPercentDto;
import cn.com.duiba.tuia.news.center.dto.req.SlotPercentReq;

import java.util.List;

/**
 * description: 广告投放配置remoteService
 *
 * author: zhangrui
 * date: 2018/9/25 13:36
 */
@AdvancedFeignClient
public interface RemoteSlotPercentService {

    /**
     * 根据图位类型查询广告投放配置集合
     * @param slotType
     * @return
     */
    List<SlotPercentDto> selectListBySlotType(Integer slotType);

    /**
     * 更新广告投放配置
     * @param req
     */
    boolean updateLaunchConfig(SlotPercentReq req);

    /**
     * 实时查询广告间隔
     * @return
     */
    String getAdvertInterval();

    /**
     * 缓存中查询广告投放配置
     * @return
     */
    List<SlotPercentDto> getSlotConfigFromCache();

    /**
     * 缓存中查询广告间隔
     * @return
     */
    Integer getAdvertIntervalFromCache();
}
