package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.landtools.AssisSuccessDto;
import cn.com.duiba.tuia.news.center.dto.req.WeChatStaticsCenterReq;

/**
 * Created by xiaotian on 2018/5/29.
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteWechatService {

    String getWechatTicket();

    String getDangerWechatTicket(Integer dangerLevel);


    /**
     * 收集微信信息
     * @param weChatStaticsCenterReq
     * @return
     */
    boolean getWechatStatics(WeChatStaticsCenterReq weChatStaticsCenterReq);

    /**
     * 获取微信openid
     * @param code
     * @return
     */
    String getOpenidByCode(String code);


    /**
     * 根据code返回微信uuid
     */
    AssisSuccessDto getAssisSuccessInfo2(String code,Integer dangerLevel) throws BizException;
}
