package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.xcx.*;

import java.util.List;

/**
 * 微信小程序相关api
 */
@AdvancedFeignClient
public interface RemoteWechatXcxService {

    boolean isNewUser(WechatXcxUserDto wechatXcxUserDto);

    boolean isNewUserNotCreate(WechatXcxUserDto wechatXcxUserDto);

    void createAcount4OldUser(String openId);

    /**
     * 回访奖励接口
     *
     * @param shareOpenId 分享者
     * @param visitOpenId 回访者
     * @param artId       文章ID
     */
    void shareVisit(String shareOpenId, String visitOpenId, Long artId);

    /**
     * 文章分享接口
     *
     * @param shareOpenId 分享者
     * @param artId       文章ID
     */
    Long share(String shareOpenId, Long artId);

    /**
     * 获取用户分享回访奖励
     *
     * @param openId
     * @return
     */
    VisitRewardRsp rewardInfo(String openId);

    /**
     * 获取用户账户信息
     *
     * @param openId
     * @return
     */
    WechatXcxUserAccountDto userAccountInfo(String openId);

    /**
     * 用户授权接口
     * 首次授权发送金币奖励
     *
     * @param openId
     * @return
     */
    public Long userAuthAndReward(String openId);

    /**
     * 获取用户状态
     *
     * @param openId
     * @return
     */
    public WechatUserStatus getUserStatus(String openId);

    /**
     * 查询用户金币流水
     *
     * @param id     最后一条流水ID
     * @param openId 用户ID
     * @param ud     0：下拉；1：上拉
     * @return
     */
    public List<AccountRecordDto> pageAccountRecordByUser(Long id, String openId, int ud);

    /**
     * 用户添加小程序操作
     *
     * @param openId
     * @return
     */
    public Long userAddXcx(String openId);

    /**
     * 获取用户每日阅读任务进度
     *
     * @param openId
     * @return
     */
    public UserTaskCountDto getUserTaskCount(String openId);

    /**
     * 记录用户文章阅读任务进度
     *
     * @param openId
     */
    public void userReadCount(String openId, Long arcId);

    /**
     * 邀请新用户
     *
     * @param shareOpenId
     * @param visitOpenId
     */
    public void inviteNewUser(String shareOpenId, String visitOpenId);

    /**
     * 领取阅读任务奖励
     *
     * @param openId
     * @return
     */
    public VisitRewardRsp getReadTaskReward(String openId);

    /**
     * 领取分享任务奖励
     *
     * @param openId
     * @return
     */
    public VisitRewardRsp getShareTaskReward(String openId);
}
