package cn.com.duiba.tuia.news.center.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xuefeng on 2018/12/11.
 */
public class QrCodeUtil {

    // 二维码颜色
    private static final int BLACK = 0xFF000000;
    // 二维码颜色
    private static final int WHITE = 0xFFFFFFFF;

    private static final int DEFAULT_WIDTH = 400;

    private static final int DEFAULT_HEIGHT = 400;

    /**
     * url生成二维码
     * @param url
     * @return
     */
    public static BufferedImage createQrCode(String url) {
        return createQrCode(url, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    /**
     * url生成二维码
     *
     * @param url
     * @param weight
     * @param height
     * @return
     */
    public static BufferedImage createQrCode(String url, int weight, int height) {
        try {
            Map<EncodeHintType, String> hints = new HashMap<>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, weight, height, hints);
            return toBufferedImage(bitMatrix);
        } catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? BLACK : WHITE);
            }
        }
        return image;
    }
}
