package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * Created by xiaotian on 2018/7/19.
 * @author xiaotian
 */
public enum OpenInstallSourceType {

    /**
     * 双倍卡分享
     */
    DOUBLE_SHARE(0),
    /**
     * 推啊引流
     */
    TUIA(1),
    /**
     * 拼手气红包
     */
    LUCK_PACKET(3),
    /**
     * 点点赚
     */
    POINT_POCKET(4),
    /**
     * 签到打卡分享
     */
    SIGN_IN_SHARE(5),
    /**
     * 热文
     */
    HOT_ARTICLE(6),
    /**
     * 限时红包
     */
    LIMIT_PACKET(7),
    /**
     * 正文分享
     */
    ARTICLE_SHARE(8),
    /**
     * 微信热文
     */
    WECHAT_HOT_ARTICLE(9),



    /**
     * 新春送财神
     */
    MAMMON(10),

    /**
     * 拼多多助力免费
     */
    PDD_HELP(11),

    /**
     * 炫耀收入
     */
    FLAUNT_INCOME(12)
    ;


    private static final Map<Integer,OpenInstallSourceType> CECHA =  Maps.uniqueIndex(Arrays.asList(values()),OpenInstallSourceType::getType);

    OpenInstallSourceType(Integer type) {
        this.type = type;
    }

    private Integer type;

    public  Integer getType() {
        return type;
    }

    public static Boolean contain(Integer type){
        for (OpenInstallSourceType openInstallSourceType: values()) {
            if (openInstallSourceType.getType().equals(type)){
                return true;
            }
        }
        return false;
    }


    public static OpenInstallSourceType getByType(Integer type) {
        OpenInstallSourceType openInstallSourceType = CECHA.get(type);
        if (openInstallSourceType != null) {
            return openInstallSourceType;
        }
        return null;
    }


}
