package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AppVersionDto;
import cn.com.duiba.tuia.news.center.dto.ConfigDto;
import cn.com.duiba.tuia.news.center.enums.AppType;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author ElinZhou
 * @version $Id: RemoteAppVersionService.java , v 0.1 2018/1/4 下午8:09 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteAppVersionService {


    /**
     * 查询最新的版本
     *
     * @param appType
     * @return
     */
    AppVersionDto queryTheLatestVersion(AppType appType);

    /**
     * 获取权限版本(1.3.0以前用户手动abTest时候临时创建的接口，现在不使用了，不维护了)
     * @return
     */
    @Deprecated
    List<String> getVersionList();

    /**
     * 获取全局配置信息
     * @return
     */
    Map<String,Object> getConfig();

    /**
     * 根据key集合获取对应配置
     * @param keys key集合， 可为空，如果为空，返回全部配置
     * @return
     */
    Map<String, String> getConfigV2(Set<String> keys);

    /**
     * 更新配置文件接口
     */
    Boolean updateConfig(ConfigDto configDto);

}
