package cn.com.duiba.tuia.news.center.enums.xcx;

public enum AcountRecordType {

    SHARE_REWARD(0, "分享奖励"),
    VISIT_REWARD(1, "回访奖励"),
    HUAFEI_CHANGE(2, "话费兑换"),
    FIRST_AUTH_REWARD(3, "首次授权奖励"),
    DAY_FIRST_SHARE_REWARD(4, "每日首次分享奖励"),
    SIGN_REWARD(5, "每日签到奖励"),
    INVITE_REWARD(6, "邀请好友奖励"),
    READ_TASK_REWARD(7, "每日阅读任务奖励"),
    ADD_XCX_REWARD(8,"添加小程序奖励"),
    SHARE_TASK_REWARD(9, "每日分享任务奖励");

    private Integer code;

    private String desc;

    AcountRecordType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static AcountRecordType getByCode(int code) {
        for (AcountRecordType type : AcountRecordType.values()) {
            if (type.getCode() - code == 0) {
                return type;
            }
        }
        return null;
    }
}

