package cn.com.duiba.tuia.news.center.enums;

import java.util.Random;
import java.util.stream.Stream;

/**
 * 随机奖品
 */
public interface RandomReward extends Reward {

    /**
     * 随机某个获取奖项
     *
     * @param randomRewards 奖项列表
     * @return 某个奖项
     */
    static RandomReward getReward(RandomReward[] randomRewards) {
        int totalRate = Stream.of(randomRewards).mapToInt(RandomReward::getRate).sum();

        // 获取随机数
        int randomNumber = new Random().nextInt(totalRate) + 1;

        int last = 0;
        for (RandomReward randomReward : randomRewards) {
            if (randomNumber > last && randomNumber <= last + randomReward.getRate()) {
                return randomReward;
            }
            last += randomReward.getRate();
        }

        throw new RuntimeException("不存在的奖项");
    }

    /**
     * 获取奖项中的随机奖励额
     *
     * @return 奖金
     */
    @Override
    default Long getRewardFee() {
        return new Random().nextInt(getMax().intValue() - getMin().intValue() + 1) + getMin();
    }

    Long getMin();

    Long getMax();

    Integer getRate();
}
