package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Auther: wsz
 * @Date: 2018/8/16 17:25
 * @Description:
 */
public enum DailyTaskEnum {
    DAILY_SIGN(1,0,"每日签到"),
    READING(2,0,"阅读文章"),
    PLANT_PACKET(3,0,"种植红包"),
    LIMITED_PACKET(4,1,"限时红包"),
    INVITE_FRIEND(5,1,"邀请好友"),
    GROUP_PACKET(6,1,"拼手气群红包"),
    WAKEUP_FRIEND(7,1,"唤醒好友")
    ;
    //基础任务列表
    private static final List<DailyTaskEnum> BASE_TASK_LIST = Stream.of(DailyTaskEnum.values()).filter((DailyTaskEnum task)-> task.getTaskType().equals(0)).collect(Collectors.toList());
    //进阶任务列表
    private static final List<DailyTaskEnum> ADVANCED_TASK_LIST = Stream.of(DailyTaskEnum.values()).filter((DailyTaskEnum task)-> task.getTaskType().equals(1)).collect(Collectors.toList());
    //基础任务
    private static final Map<Integer, DailyTaskEnum> BASE_TASK = Maps.uniqueIndex(Stream.of(DailyTaskEnum.values()).filter((DailyTaskEnum task)-> task.getTaskType().equals(0)).collect(Collectors.toList()),
            DailyTaskEnum::getTaskId);
    //进阶任务
    private static final Map<Integer, DailyTaskEnum> ADVANCED_TASK = Maps.uniqueIndex(Stream.of(DailyTaskEnum.values()).filter((DailyTaskEnum task)-> task.getTaskType().equals(1)).collect(Collectors.toList()),
            DailyTaskEnum::getTaskId);
    private static final Map<Integer, DailyTaskEnum> CACHE = Maps.uniqueIndex(Arrays.asList(DailyTaskEnum.values()),DailyTaskEnum::getTaskId);
    /** 任务id*/
    private Integer taskId;
    /** 任务类型 0:基础任务 2:进阶任务*/
    private Integer taskType;
    /** 任务名称*/
    private String taskName;

    DailyTaskEnum(Integer taskId, Integer taskType, String taskName) {
        this.taskId = taskId;
        this.taskType = taskType;
        this.taskName = taskName;
    }

    public Integer getTaskId() {
        return taskId;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public String getTaskName() {
        return taskName;
    }

    public static DailyTaskEnum getByTaskId(Integer taskId) {
        return CACHE.get(taskId);
    }
    public static List<DailyTaskEnum> getBaseTask() {
        return BASE_TASK_LIST;
    }
    public static List<DailyTaskEnum> getAdvancedTask() {
        return ADVANCED_TASK_LIST;
    }
    public static DailyTaskEnum getBaseTaskByTaskId(Integer taskId) {
        return BASE_TASK.get(taskId);
    }
    public static DailyTaskEnum getAdvancedTaskByTaskId(Integer taskId) {
        return ADVANCED_TASK.get(taskId);
    }
}
