package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.LandPageDto;

import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteLandPageService.java , v 0.1 2018/8/1 下午3:15 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteLandPageService {

    /**
     * 插入落地页
     *
     * @return
     */
    Long insertLandPage(LandPageDto landPageDto);

    /**
     * 更新落地页
     *
     * @return
     */
    Boolean updateLandPage(LandPageDto landPageDto);

    /**
     * 查询落地页
     *
     * @param id
     * @return
     */
    LandPageDto queryById(Long id);

    /**
     * 分页查询所有落地页
     *
     * @param page
     * @param pageSize
     * @return
     */
    List<LandPageDto> list(Integer page, Integer pageSize);

}
