package cn.com.duiba.tuia.news.center.dto.push;

import cn.com.duiba.tuia.news.center.enums.MessageStyleType;
import com.alibaba.fastjson.JSON;

import java.io.Serializable;
import java.util.List;

/**
 * 应用内消息通知
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: CustomMessageDto.java , v 0.1 2019-03-07 15:42 ElinZhou Exp $
 */
public class CustomMessageDto implements Serializable {

    private static final long serialVersionUID = 2144097023828041302L;
    /**
     * 样式类型
     */
    private MessageStyleType styleType;

    /**
     * 跳转类型 0.不跳转 1.原生页面跳转 2.web跳转
     */
    private int jumpType;

    private String title;

    private String desc;

    private List<String> images;

    private String jumpUrl;


    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

    public MessageStyleType getStyleType() {
        return styleType;
    }

    public void setStyleType(MessageStyleType styleType) {
        this.styleType = styleType;
    }

    public int getJumpType() {
        return jumpType;
    }

    public void setJumpType(int jumpType) {
        this.jumpType = jumpType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public List<String> getImages() {
        return images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public static void main(String... args) {
        CustomMessageDto customMessageDto = new CustomMessageDto();
        System.out.println(customMessageDto.toString());
    }
}
