package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.GuaFenWheelDto;
import cn.com.duiba.tuia.news.center.dto.ShiFuGuaFenDto;

import java.util.List;

/**
 * 全民大拜师的service
 *
 * @author lichao 2019/3/20
 */
@AdvancedFeignClient
public interface RemoteShiFuService {

    /**
     * 瓜分1亿分享成功
     *
     * @param userId
     */
    void guafenShareSuccess(Long userId);

    /**
     * 增加瓜分1亿的回访
     *
     * @param userId 用户id
     * @param openId 用户微信id
     */
    void addNoticeUser(Long userId, String openId);

    /**
     * 查询自己的瓜分历史
     * @param userId
     * @return
     */
    List<ShiFuGuaFenDto> getGuaFenList(Long userId,Integer limit);

    /**
     * 瓜分1亿的轮播
     * @return
     */
    List<GuaFenWheelDto> getWheelList(Long userId);
}
