package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.ChangeOrderDto;

import java.util.List;

/**
 * @author ElinZhou
 * @version $Id: RemoteCoinOrderService.java , v 0.1 2017/12/30 下午3:49 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteChangeOrderService {

    /**
     * 通过userId和流水号查询订单
     *
     * @param userId
     * @param serialNumber
     * @return 存在订单时返回订单，不存在返回null
     */
    ChangeOrderDto queryOrderBySerialNumber(Long userId, Long serialNumber) throws BizException;

    /**
     * 分页查询用户流水 按时间倒序
     *
     * @param userId
     * @param page     页码
     * @param pageSize 每页数量
     * @return
     */
    List<ChangeOrderDto> queryUserOrder(Long userId, Integer page, Integer pageSize) throws BizException;

    /**
     * 查询记录数
     *
     * @param userId
     * @return 记录数
     * @throws BizException
     */
    Long queryCountByUserId(Long userId) throws BizException;
}
