package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.enums.ChangeTradeCode;
import cn.com.duiba.tuia.news.center.enums.CoinTradeCode;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteCoinService.java , v 0.1 2018/6/7 下午6:42 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteCoinService {

    /**
     * 金币账户变动
     * 当fee>0时，code使用cn.com.duiba.tuia.news.center.enums.RewardTaskType
     * 当fee<0时，code使用cn.com.duiba.tuia.news.center.enums.CoinExpenseCode
     */
    Long change(Long userId, Long fee, CoinTradeCode code);


    /**
     * 余额账户变动
     *  当fee>0时，code使用cn.com.duiba.tuia.news.center.enums.ChangeIncomeCode
     *  当fee<0时，code使用cn.com.duiba.tuia.news.center.enums.ChangeExpenseCode
     *
     * @return
     */
    Long changeChange(Long userId, Long fee, ChangeTradeCode code);


}
