/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum PointSysType {
    APP(0, "app"),
    WECHAT(1, "WECHAT");

    private Integer code;
    private String description;
    private static final Map<Integer, PointSysType> CACHE;

    private PointSysType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static PointSysType getByCode(Integer code) {
        PointSysType pointSysType = CACHE.get(code);
        if (pointSysType != null) {
            return pointSysType;
        }
        return APP;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(PointSysType.values()), PointSysType::getCode);
    }
}

