/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums.loginReward;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.support.ManagedMap;

public enum LoginRewardEnum {
    LOGIN(1, "\u767b\u5f55\u5929\u5929\u8da3\u95fb", 1L, 0L, 0xFFFFFFFFFFL),
    READ(2, "\u9605\u8bfb5\u7bc7\u6587\u7ae0", 5L, 0L, 0x108080000L),
    READ2(2, "\u9605\u8bfb2\u5206\u949f\u6587\u7ae0", 6L, 0x108080000L, 0xFFFFFFFFFFL),
    PLANT(3, "\u79cd\u690d3\u4e2a\u7ea2\u5305", 3L, 0L, 0xFFFFFFFFFFL),
    TREE(4, "\u79cd\u690d\u6447\u94b1\u6811", 1L, 0L, 0xFFFFFFFFFFL);

    private Integer taskId;
    private String taskDescription;
    private Long allPlan;
    private Long versionStart;
    private Long versionEnd;
    private static final Map<Integer, List<LoginRewardEnum>> CACHE;

    public Long getVersionStart() {
        return this.versionStart;
    }

    public Long getVersionEnd() {
        return this.versionEnd;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public Long getAllPlan() {
        return this.allPlan;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    private LoginRewardEnum(Integer taskId, String taskDescription, Long allPlan, Long versionStart, Long versionEnd) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
        this.allPlan = allPlan;
        this.versionStart = versionStart;
        this.versionEnd = versionEnd;
    }

    public static LoginRewardEnum getByTaskId(Integer taskId, Long version, Long userId) {
        List<LoginRewardEnum> rewardTaskTypeList = CACHE.get(taskId);
        LoginRewardEnum result = LOGIN;
        if (CollectionUtils.isNotEmpty(rewardTaskTypeList)) {
            for (LoginRewardEnum loginRewardEnum : rewardTaskTypeList) {
                if (version >= 4446224384L && userId % 2L == 1L && READ.getTaskId().equals(taskId)) {
                    return READ;
                }
                if (loginRewardEnum.getVersionStart() > version || loginRewardEnum.getVersionEnd() <= version) continue;
                result = loginRewardEnum;
                break;
            }
        }
        return result;
    }

    static {
        CACHE = (Map)Arrays.stream(LoginRewardEnum.values()).collect(Collectors.groupingBy(LoginRewardEnum::getTaskId, ManagedMap::new, Collectors.toList()));
    }
}

