package cn.com.duiba.tuia.news.center.dto.downloadconfig;

import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DownloadAppConfigDto implements Serializable{
    private static final long serialVersionUID = 4829526805859346896L;
    private Long id;

    /**
     * app包名称
     */
    private String appPackage;

    /**
     * app名称
     */
    private String appName;

    /**
     * app奖励 （分）
     */
    private Integer reward;

    /**
     * app大小
     */
    private Long appSize;

    /**
     * 下载链接
     */
    private String downloadUrl;

    /**
     * App Logo 图片
     */
    private String appLogo;

    /**
     * app 详情图片
     */
    private String imagesUrls;

    /**
     * app 描述
     */
    private String appDesc;

    /**
     * 应用启用状态
     */
    private Integer enableStatus;

    /**
     * 应用排序
     */
    private Integer appSort;

    /**
     * 应用来源
     */
    private Integer appSource;

    /**
     * 广告计划id
     */
    private String advertId;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 最低版本支持
     */
    private Long versionStart;

    /**
     * 奖励配置设置
     */
    private RewardSettingDto rewardSettingDto;

    /**
     * 更新奖励配置时 新增版本
     */
    private Long updateVersion;

    /**
     * 曝光数据
     */
    private Long appExposure;

    /**
     * 点击数据
     */
    private Long appClick;

    /**
     * 业务场景 {@link cn.com.duiba.tuia.news.center.enums.AdGroupCode}
     */
    private Integer adGroup;



    public List<String> getImgs(){
        try {
            JSONObject jsonObject = JSONObject.parseObject(imagesUrls);
            if (null != jsonObject){
                List<String> imgList = jsonObject.entrySet().stream().sorted(Map.Entry.comparingByKey()
                ).map(Map.Entry::getValue).map(Object::toString).collect(Collectors.toList());
                return imgList;
            }

        }catch (Exception e){
            return Collections.emptyList();
        }

        return Collections.emptyList();
    }

    public Integer getAdGroup() {
        return adGroup;
    }

    public void setAdGroup(Integer adGroup) {
        this.adGroup = adGroup;
    }

    public Long getVersionStart() {
        return versionStart;
    }

    public void setVersionStart(Long versionStart) {
        this.versionStart = versionStart;
    }

    public RewardSettingDto getRewardSettingDto() {
        return rewardSettingDto;
    }

    public void setRewardSettingDto(RewardSettingDto rewardSettingDto) {
        this.rewardSettingDto = rewardSettingDto;
    }

    public Long getUpdateVersion() {
        return updateVersion;
    }

    public void setUpdateVersion(Long updateVersion) {
        this.updateVersion = updateVersion;
    }

    public String getAdvertId() {
        return advertId;
    }

    public void setAdvertId(String advertId) {
        this.advertId = advertId;
    }

    public String getImagesUrls() {
        return imagesUrls;
    }

    public void setImagesUrls(String imagesUrls) {
        this.imagesUrls = imagesUrls;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage == null ? null : appPackage.trim();
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    public Integer getReward() {
        return reward;
    }

    public void setReward(Integer reward) {
        this.reward = reward;
    }

    public Long getAppSize() {
        return appSize;
    }

    public void setAppSize(Long appSize) {
        this.appSize = appSize;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl == null ? null : downloadUrl.trim();
    }

    public String getAppLogo() {
        return appLogo;
    }

    public void setAppLogo(String appLogo) {
        this.appLogo = appLogo == null ? null : appLogo.trim();
    }

    public String getAppDesc() {
        return appDesc;
    }

    public void setAppDesc(String appDesc) {
        this.appDesc = appDesc == null ? null : appDesc.trim();
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getAppSort() {
        return appSort;
    }

    public void setAppSort(Integer appSort) {
        this.appSort = appSort;
    }

    public Integer getAppSource() {
        return appSource;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getAppExposure() {
        return appExposure;
    }

    public void setAppExposure(Long appExposure) {
        this.appExposure = appExposure;
    }

    public Long getAppClick() {
        return appClick;
    }

    public void setAppClick(Long appClick) {
        this.appClick = appClick;
    }
}