package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.JumpConfigDto;
import cn.com.duiba.tuia.news.center.dto.req.jumpconfig.JumpConfigReq;

import java.util.List;

/**
 * description: 跳转配置 remote service
 *
 * author: zhangrui
 * date: 2018/9/10 21:12
 */
@AdvancedFeignClient
public interface RemoteJumpConfigService {

    /**
     * 查询所有配置记录
     * @return
     */
    List<JumpConfigDto> selectAllList(Integer userType,Integer categoryType);

    /**
     * 根据主键删除单条记录
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 选择性插入
     * @param record
     * @return
     */
    int insertSelective(JumpConfigDto record);

    /**
     * 根据主键查询单条记录
     * @param id
     * @return
     */
    JumpConfigDto selectByPrimaryKey(Long id);

    /**
     * 根据主键选择性更新单条记录
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(JumpConfigDto record);

    /**
     *根据主键全更新单条记录
     * @param record
     * @return
     */
    int updateByPrimaryKey(JumpConfigDto record);

    /**
     * 根据平台与版本查询列表与CategoryType
     */
    List<JumpConfigDto> selectByCategoryType(JumpConfigReq jumpConfigReq);


    /**
     * 根据平台与版本查询列表与categoryItem
     */
    List<JumpConfigDto> selectByCategoryItem(JumpConfigReq jumpConfigReq);


    /**
     * 查询所有
     */
    List<JumpConfigDto> selectAll(Long version);
}
