package cn.com.duiba.tuia.news.center.dto.advert;

import java.io.Serializable;
import java.util.Map;

/**
 * @Description: 新版本广告配置  区别与  {@link cn.com.duiba.tuia.news.center.dto.flowadvert.AdvertConfigDto}
 * @Author: Zhou_wb
 * @Date: 2019/3/12 17:38
 */
public class NewAdvertConfigDto implements Serializable {

    private static final long serialVersionUID = 2510292301784429606L;
    private Long id;

    /**
     * 第三方广告位id
     */
    private String slotId;

    /**
     * 获取方式 0：后台获取 1：客户端获取
     */
    private Integer fetchType;

    /**
     * 广告位类型 TUIA_BIG :推啊大图 TUIA_SMALL 推啊小图..
     */
    private String slotType;

    /**
     * 广告名称
     */
    private String slotName;

    /**
     * 广告最低支持版本
     */
    private Long versionStart;

    /**
     * 第三方广告额外字段
     */
    private Map<String,Object> extra;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSlotId() {
        return slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public Integer getFetchType() {
        return fetchType;
    }

    public void setFetchType(Integer fetchType) {
        this.fetchType = fetchType;
    }

    public String getSlotType() {
        return slotType;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getVersionStart() {
        return versionStart;
    }

    public void setVersionStart(Long versionStart) {
        this.versionStart = versionStart;
    }

    public Map<String, Object> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }
}
