package cn.com.duiba.tuia.news.center.dto.req;

import cn.com.duiba.tuia.news.center.enums.AndroidPushCustomEnum;
import cn.com.duiba.tuia.news.center.enums.message.MessageCode;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Map;

/**
 *  系统消息的推送信息
 *  @author lichao 2018/12/4
 */
public class UserSystemMessagePush implements Serializable {

    //标题
    private String title;

    //消息
    private String message;

    //消息的跳转的页面
    private AndroidPushCustomEnum pushType;

    //推送使用的其他参数
    private Map<String,Object> extra;

    //是否推送
    private boolean isPush;

    private Integer relationType;

    public void addData(String key,Object value){
        if(extra==null){
            extra = Maps.newHashMap();
        }
        extra.put(key,value);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AndroidPushCustomEnum getPushType() {
        return pushType;
    }

    public void setPushType(AndroidPushCustomEnum pushType) {
        this.pushType = pushType;
    }

    public Map<String, Object> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public boolean isPush() {
        return isPush;
    }

    public void setPush(boolean push) {
        isPush = push;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }
}
