package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: AppType.java , v 0.1 2018/1/4 下午8:00 ElinZhou Exp $
 */
public enum ApplyRelationType {

    APPLY(0, "申请"),
    AGREE(1,"同意"),
    REJECT(2, "拒绝"),;


    private Integer code;

    private String description;

    ApplyRelationType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<Integer, ApplyRelationType> CACHE = Maps.uniqueIndex(Arrays.asList(ApplyRelationType.values()),
            ApplyRelationType::getCode);

    public static ApplyRelationType getByCode(Integer code) {
        ApplyRelationType applyRelationType = CACHE.get(code);
        if (applyRelationType != null) {
            return applyRelationType;
        }
        return null;
    }

}
