package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

import static cn.com.duiba.tuia.news.center.enums.RewardUnit.CHANGE;

public enum NewUserSignInRewardV2 implements SignInReward {

                                                         DAY_ONE(1, 0L, CHANGE),

                                                         DAY_TWO(2, 2L, CHANGE),

                                                         DAY_THREE(3, 1L, CHANGE),

                                                         DAY_FOUR(4, 1L, CHANGE),

                                                         DAY_FIVE(5, 2L, CHANGE),

                                                         DAY_SIX(6, 1L, CHANGE),

                                                         DAY_SEVEN(7, 3L, CHANGE);

    private Integer             day;
    private Long                rewardFee;
    private RewardUnit          rewardUnit;

    private static final Map<Integer, NewUserSignInRewardV2> CACHE = Maps.uniqueIndex(Arrays.asList(NewUserSignInRewardV2
            .values()), NewUserSignInRewardV2::getDay);

    NewUserSignInRewardV2(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        switch (rewardFee.intValue()){
            case 0:// 0则说明是现金奖励在(0.1,0.3]之间（2018-04-27 改为奖励在（0.1,0.7]之间）(2018-05-04 奖励改为[0.25,0.27]之间)）
                //05.10改为0.45-0.55
                Integer reward0 = 108;
                return reward0.longValue();
            case 1:// -1则说明是现金奖励在(0,0.2]之间
                Integer reward1 = new Random().nextInt(20) + 1;
                return reward1.longValue();
            case 2://调用新的概率分布奖励枚举
                RandomReward loginRewardSignInReward = RandomReward.getReward(LoginRewardSignInReward.values());
                return loginRewardSignInReward.getRewardFee();
            case 3:
                Integer reward3 = new Random().nextInt(30) + 20;
                return reward3.longValue();
            default:
                return 0L;
        }
    }

    @Override
    public Long getRewardFee(Integer version) {
        switch (rewardFee.intValue()){
            case 0:// 0则说明是现金奖励在(0.1,0.3]之间（2018-04-27 改为奖励在（0.1,0.7]之间）(2018-05-04 奖励改为[0.25,0.27]之间)）
                //05.10改为0.45-0.55
                Integer reward0 = 108;
                if(version != null && version >= AppVersionEnum.CASH_PACKET.getVersion()) {
                    //1.5.0版本 初始奖励改为15.88
                    reward0 = 1588;
                }
                return reward0.longValue();
            case 1:// -1则说明是现金奖励在(0,0.2]之间
                Integer reward1 = new Random().nextInt(20) + 1;
                return reward1.longValue();
            case 2://调用新的概率分布奖励枚举
                RandomReward loginRewardSignInReward = RandomReward.getReward(LoginRewardSignInReward.values());
                return loginRewardSignInReward.getRewardFee();
            case 3:
                Integer reward3 = new Random().nextInt(30) + 20;
                return reward3.longValue();
            default:
                return 0L;
        }
    }


    @Override
    public Long getTopRewardNew() {
        switch (getRewardFee().intValue()){
            case 0:// 0则说明是现金奖励在(0.1,0.3]之间
                //todo 这些数据产品变动量太大，所以没有放枚举（待优化）
                return 30L;
            case 1:// -1则说明是现金奖励在(0,0.2]之间
                return 20L;
            case 2://调用新的概率分布奖励枚举
                return 50L;
            case 3:
                return 20000L;
            default:
                return 0L;
        }
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public static NewUserSignInRewardV2 getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("签到异常"));
    }
    public static Long getTopReward(Integer day) {
        return NewUserSignInRewardV2.getByDay(day).getTopRewardNew();
    }




}
