package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author xiaotian
 */
public enum PointSysType {

    /**
     * app端的请求
     */
    APP(0, "app"),

    /**
     * wechat端的请求
     */
    WECHAT(1, "WECHAT");


    private Integer code;

    private String description;

    PointSysType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    private static final Map<Integer, PointSysType> CACHE = Maps.uniqueIndex(Arrays.asList(PointSysType.values()),
            PointSysType::getCode);

    public static PointSysType getByCode(Integer code) {
        PointSysType pointSysType = CACHE.get(code);
        if (pointSysType != null) {
            return pointSysType;
        }
        return APP;
    }


    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
