package cn.com.duiba.tuia.news.center.enums;

/**
 * 奖励任务领取限制时间单位
 *
 * @author ElinZhou
 * @version $Id: RewardTimeUnit.java , v 0.1 2017/12/31 下午9:31 ElinZhou Exp $
 */
public enum RewardTimeUnit {

    /**
     * 每天
     */
    DAY(1),;

    private Integer code;

    RewardTimeUnit(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static RewardTimeUnit of(Integer aCode){
        if (aCode == null){
            return null;
        }
        for (RewardTimeUnit rewardTimeUnit : values()) {
            if(rewardTimeUnit.getCode().equals(aCode)){
                return rewardTimeUnit;
            }
        }
        return null;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }
}
