package cn.com.duiba.tuia.news.center.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: UserLocationUpdatePriority.java , v 0.1 2019-02-13 14:41 ElinZhou Exp $
 */
public enum UserLocationUpdatePriority {

    /**
     * 定位或主动选择
     */
    LOCATE(1),

    /**
     * 手机归属地
     */
    PHONE_GEO(2),

    /**
     * ip定位
     */
    IP_GEO(3),

    /**
     * 微信登记位置
     */
    WECHAT(4),
    ;

    private static Map<Integer, UserLocationUpdatePriority> CACHE =
            Arrays.stream(UserLocationUpdatePriority.values()).collect(Collectors.toMap(e -> e.priority, e -> e));

    int priority;

    UserLocationUpdatePriority(int priority) {
        this.priority = priority;
    }

    public static UserLocationUpdatePriority of(int priority) {
        return CACHE.get(priority);
    }

    public int getPriority() {
        return priority;
    }}
