package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: ValidStatusEnum.java , v 0.1 2018/7/19 下午2:29 ElinZhou Exp $
 */
public enum ValidStatusEnum {

    /**
     * 已删除
     */
    DELETED(0),

    /**
     * 无效
     */
    INVALID(1),

    /**
     * 有效
     */
    VAILD(2),;

    private Integer code;

    private static final Map<Integer, ValidStatusEnum> CACHE = Maps.uniqueIndex(Arrays.asList(ValidStatusEnum
            .values()), ValidStatusEnum::getCode);

    ValidStatusEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static ValidStatusEnum of(Integer code) {
        return CACHE.get(code);
    }


}
