package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.coinbox.CoinBoxConfigDto;
import cn.com.duiba.tuia.news.center.dto.coinbox.CoinBoxDto;
import cn.com.duiba.tuia.news.center.dto.coinbox.CoinBoxReadingReqDto;

/**
 * 金币宝箱
 * @author wsz
 * @date 2019/1/8 11:04
 */
@AdvancedFeignClient
public interface RemoteCoinBoxService {
    /**
     * 获取金币宝箱
     */
    CoinBoxDto getCoinBox(Long userId) throws BizException;

    /**
     * 获取金币收益
     * @param boxId 宝箱id
     * @param userId 用户id
     */
    CoinBoxConfigDto getCoinReward(Long boxId, Long userId) throws BizException;

    /**
     * 获得宝箱阅读奖励
     */
    void getCoinBoxReadingReward(CoinBoxReadingReqDto reqDto);
}
