package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.FinancialStatisticsQueryDto;
import cn.com.duiba.tuia.news.center.dto.FinanicalStatisticsAllDto;
import cn.com.duiba.tuia.news.center.dto.FinanicalStatisticsDetailDto;
import cn.com.duiba.tuia.news.center.dto.FinanicalStatisticsDto;

import java.util.Date;
import java.util.List;

/**
 * Created by xiaotian on 2018/4/17.
 */
@AdvancedFeignClient
public interface RemoteFinancialStatisticsService {
    /**
     * 根据时间统计每天统计数据（申请提现总额，成功提现总额，申请提现笔数，成功提现笔数）
     * @return
     */
    FinanicalStatisticsAllDto queryStatisticsListByTime(FinancialStatisticsQueryDto financialStatisticsQueryDto);

    /**
     *  根据查询时间统计那天的统计数据（申请提现总额，成功提现总额，申请提现笔数，成功提现笔数）根据提现金额group by 然后根据金额大小顺序排列
     * @param day
     * @return
     */
    List<FinanicalStatisticsDetailDto> queryStatisticsDetailByTime(Date day);

}
