package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.MoneyTreeConfigDto;
import cn.com.duiba.tuia.news.center.dto.MoneyTreeDto;
import cn.com.duiba.tuia.news.center.dto.MoneyTreePlantDto;
import cn.com.duiba.tuia.news.center.dto.moneyTree.PlantReq;

import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteMoneyTreeService.java , v 0.1 2018-12-24 13:57 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteMoneyTreeService {

    /**
     * 查询昨日金币收入
     * 当今日收获过金币后，将无法获取该数值
     *
     * @param userId
     * @return 最后有收获过金币的一天获得的总金币
     */
    long queryLastIncome(Long userId);


    /**
     * 摘取获得金币
     *
     * @param userId 金币数
     * @param coins  收获零钱数
     */
    void pick(Long userId, Long coins);

    /**
     * 种植(废弃，不要调用，后果狠严重)
     * @param userId
     * @return 连续种植时间
     */
    @Deprecated
    MoneyTreePlantDto plant(Long userId);


    /**
     * 种植(在1.8.4版本之前不发券)
     *
     * @param plantReq
     * @return 连续种植时间
     */
    MoneyTreePlantDto plantV2(PlantReq plantReq);

    /**
     * 查询种植情况
     *
     * @param userId
     * @return
     */
    MoneyTreeDto queryPlant(Long userId);

    /**
     * 查询摇钱树广告指定配置
     * @return
     */
    List<MoneyTreeConfigDto> selectAllAds();

    /**
     * 删除摇钱树广告指定配置
     * @param id
     * @return
     */
    Boolean deleteAd(Long id);

    /**
     * 新增or更新 摇钱树广告指定配置
     * @param list
     * @return
     */
    Boolean updateAd(List<MoneyTreeConfigDto> list);
}
