package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.ActivityShareDetailReq;
import cn.com.duiba.tuia.news.center.dto.req.SignInSharePageReq;
import cn.com.duiba.tuia.news.center.dto.rsp.SignInSharePageDto;

/**
 * @Auther: wsz
 * @Date: 2018/8/27 11:21
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteSignInShareService {
    /**
     * 获取签到分享页详情
     * @param req
     * @return
     */
    SignInSharePageDto getSignInSharePage(SignInSharePageReq req);

    /**
     * 领取分享奖励
     * @param userId
     */
    void getShareReward(Long userId) throws BizException;

    /**
     * 获取打卡活动页详情
     * @param req
     * @return
     */
    SignInSharePageDto getActivityShareDetail(ActivityShareDetailReq req) throws BizException;
}
