package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.PersonaDto;
import cn.com.duiba.tuia.news.center.dto.UserInfoUpdateDto;

/**
 * 用户信息接口
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteUserInfoService.java , v 0.1 2019-02-13 11:54 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteUserInfoService {

    /**
     * 查询用户信息
     *
     * @param userId
     */
    PersonaDto queryInfo(Long userId);

    /**
     * 更新用户信息
     *
     * @param dto   信息
     * @param sence 更新场景
     * @see cn.com.duiba.tuia.news.center.enums.UserLocationUpdatePriority
     */
    void update(UserInfoUpdateDto dto, int sence);


}
