package cn.com.duiba.tuia.news.center.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.withdrawTask.DetailDto;
import cn.com.duiba.tuia.news.center.dto.withdrawTask.JumpDto;

/**
 * @author ElinZhou
 * @version $Id: RemoteWithdrawService.java , v 0.1 2018/1/3 上午11:13 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteWithdrawTaskService {

    /**
     * 根据获取是否完成提现插队任务
     * @param serialNumber
     * @return
     */
    DetailDto getStatusBySerialNumber(Long serialNumber);

    /**
     * 插队
     * @param userId
     * @param serialNumber
     * @return
     */
    JumpDto jump(Long userId, Long serialNumber) throws BizException;

}
