package cn.com.duiba.tuia.news.center.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.collect.Maps;
import org.w3c.dom.stylesheets.LinkStyle;

/**
 * 零钱收入码
 *
 * @author ElinZhou
 * @version $Id: ChangeIncomeCode.java , v 0.1 2017/12/30 下午6:48 ElinZhou Exp $
 */
public enum ChangeIncomeCode  implements ChangeTradeCode{

                                                         /**
                                                          * 结算
                                                          */
                                                         SETTLE(1, "金币兑换现金"),

                                                         /**
                                                          * 新用户奖励
                                                          */
                                                         NEW_USER_REWARD(2, "新用户奖励"),

                                                         /**
                                                          * 登录奖励
                                                          */
                                                         SIGN_IN(3, "签到奖励"),

                                                         /**
                                                          * 提现驳回
                                                          */
                                                         WITHDRAW_TURN_DOWN(4, "提现退还入账"),

                                                         /**
                                                          *
                                                          */
                                                         INVITE_INCOME(5,"邀请好友"),

                                                         /**
                                                          *
                                                         */
                                                         LIMIT_PECKET(6,"限时红包"),

                                                        /**
                                                         *
                                                         */
                                                        NEW_TICKET_WITHDRAW(7,"首次提现成功"),


                                                        LUCK_PACKET_SEND(8,"红包收益"),


                                                        LUCK_PACKET_RECEIVE(9,"领取红包"),

                                                        POINT_PACKET(10,"疯狂抽奖"),

                                                        NEW_USER_READING(11,"阅读文章奖励"),

                                                        NEW_USER_DRAWED(12,"收取红包奖励"),

                                                        NEW_PLAN_DRAWED(13,"收取红包奖励"),

                                                        SALE_TRIBUTE_SETTLE(14,"团队进贡结算"),

                                                        SALE_OWN_SETTLE(15,"直属佣金结算"),

                                                        LOGIN_REWARD_LOGIN(16,"新人登录奖励"),

                                                        LOGIN_REWARD_READ(17,"新人阅读奖励"),

                                                        XIANWAN_REWARD(18,"完成游戏任务"),

                                                        LOGIN_REWARD_FARM(19,"新人种植奖励"),

                                                        TRY_PLAY_REWARD(20,"试玩奖励"),

                                                        GOLD_TREE_REWARD(21,"摇钱树种植奖励"),

                                                        NEW_LOGIN_184_REWARD(22,"新人每日登录奖励"),

                                                        MAMMON(23,"财神红包"),

                                                        MIDONG_REWARD(24,"应用试玩任务奖励"),

                                                        NEW_LOGIN_REWARD_190(25,"新人登录奖励"),

                                                        SURVERY_REWARD(26,"完成问卷调研"),

                                                        YOUMI_REWARD(27,"应用试玩任务奖励")


    ;


    private Integer code;

    private String                                      desc;

    private static final Map<Integer, ChangeIncomeCode> CACHE = Maps.uniqueIndex(Arrays.asList(ChangeIncomeCode.values()),
            ChangeIncomeCode::getCode);

    ChangeIncomeCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public static ChangeIncomeCode get(Integer code) {
        return CACHE.get(code);
    }

    /**
     * 任务里面的code
     */
    public static final Set<Integer> CODE_IN_TASK = Stream.of(SIGN_IN.code
            ,INVITE_INCOME.code
            ,LIMIT_PECKET.code
            ,LUCK_PACKET_SEND.code
            ,POINT_PACKET.code
            ,NEW_USER_READING.code
            ,NEW_USER_DRAWED.code
            ,NEW_PLAN_DRAWED.code).collect(Collectors.toSet());


    public static boolean codeInTask(Integer code){
        return CODE_IN_TASK.contains(code);
    }
}
