package cn.com.duiba.tuia.news.center.enums.pdd;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: AppType.java , v 0.1 2018/1/4 下午8:00 ElinZhou Exp $
 */
public enum PddAppStatusType {

    EXPIRE(-1," 失效"),

    UNSETTLE(0, "待结算"),

    SETTLE(1, "已结算"),;


    private Integer code;

    private String description;

    PddAppStatusType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    private static final Map<Integer, PddAppStatusType> MAP = Maps.uniqueIndex(Lists.newArrayList(PddAppStatusType
            .values()), PddAppStatusType::getCode);


    public static String getDesc(Integer code){
        return MAP.get(code).getDescription();
    }


    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
