package cn.com.duiba.tuia.news.center.enums.pdd;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: AppType.java , v 0.1 2018/1/4 下午8:00 ElinZhou Exp $
 */
public enum PddIncomeType {

    OWN(1,"直属"),

    UP(2, "进贡"),;


    private Integer code;

    private String description;

    PddIncomeType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    private static final Map<Integer, PddIncomeType> MAP = Maps.uniqueIndex(Lists.newArrayList(PddIncomeType
            .values()), PddIncomeType::getCode);


    public static String getDesc(Integer code){
        return MAP.get(code).getDescription();
    }


    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
