package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.downloadconfig.DownloadAppConfigDto;
import cn.com.duiba.tuia.news.center.dto.downloadconfig.DownloadQueryDto;
import cn.com.duiba.tuia.news.center.enums.AdGroupCode;

import java.util.List;

/**
 * @author zhou_wb
 * 需求变动，临时处理返回固定
 */
@AdvancedFeignClient
public interface RemoteDownLoadConfigService {

    /**
     *添加与保存配置
     */
    boolean save(DownloadAppConfigDto downloadAppConfigDto);

    /**
     * 获取所有配置信息（后台）
     * @return
     */
    List<DownloadAppConfigDto> selectByAllForBk();

    /**
     * 获取所有配置信息（后台） 根据广告场景 {@link cn.com.duiba.tuia.news.center.enums.AdGroupCode}
     * @return
     */
    List<DownloadAppConfigDto> selectByAllForBkV2(AdGroupCode adGroupCode);



    /**
     * 获取所有配置信息（后台） 根据广告场景 {@link cn.com.duiba.tuia.news.center.enums.AdGroupCode}
     * @return
     */
    List<DownloadAppConfigDto> selectByAllForBkV3(DownloadQueryDto downloadQueryDto);



    /**
     * 获取所有配置（非后端）
     */
    List<DownloadAppConfigDto> selectAll();

    /**
     * 获取上线配置所有配置（非后端）
     */
    List<DownloadAppConfigDto> selectOnLineAll();

    /**
     * 更新排序
     * @param
     */
    void updateAppSort(List<Long> ids);


    /**
     *更新开启状态
     */
    boolean updateAppEnableStatus(Integer status, Long id);


    /**
     *删除配置
     */
    boolean delete(Long id);

    /**
     * 根据id查询信息
     */
    DownloadAppConfigDto selectById(Long id);


    void  updateEnableByBoundId(Long boundId);




    /**
     *添加与保存配置
     */
    boolean saveOfNoReward(DownloadAppConfigDto downloadAppConfigDto);


    /**
     *添加与保存配置
     */
    boolean insertBackUp(DownloadAppConfigDto downloadAppConfigDto);
}
