/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum UserActionEnum {
    READING(1, "\u9605\u8bfb"),
    ARTICLE_SHARE(2, "\u6b63\u6587\u5206\u4eab"),
    CONTACTS_RECORD(3, "\u901a\u8baf\u5f55\u8bb0\u5f55"),
    COIN_BOX(4, "\u91d1\u5e01\u5b9d\u7bb1");

    private Integer type;
    private String desc;
    private static final Map<Integer, UserActionEnum> CACHE;

    private UserActionEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static UserActionEnum getByType(Integer type) {
        return CACHE.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(UserActionEnum.values()), UserActionEnum::getType);
    }
}

